<?php

namespace App\Helpers;


class HomePageStaticSettings
{
    public $user_lang = null;

    public function __construct()
    {
        if ($this->user_lang == null) {
            $this->user_lang = LanguageHelper::user_lang_slug();
        }
    }

    public static function default_settings()
    {
        $lang = (new static())->user_lang;
        return [
            'language_select_option',
            'navbar_button',
            'navbar_button_custom_url_status',
            'navbar_' . $lang . '_button_text',
            'site_white_logo',
            'site_' . $lang . '_title',
            'product_module_status',
            'home_page_counterup_section_status',
            'home_page_service_section_status',
            'home_page_quote_faq_section_status',
            'construction_quote_section_bg_image',
            'home_page_case_study_section_status',
            'home_page_team_member_section_status',
            'home_page_testimonial_section_status',
            'home_page_latest_news_section_status',
            'home_page_brand_logo_section_status',
            'home_page_variant',
            'home_page_key_feature_section_status',
            'home_page_about_us_section_status',
            'home_page_01_about_us_video_background_image',
            'home_page_service_section_status',
            'home_page_01_service_area_item_type',
            'home_page_quality_section_status',
            'home_page_01_quality_area_background_image',
            'home_page_testimonial_section_status',
            'home_page_price_plan_section_status',
            'home_page_counterup_section_status',
            'home_page_01_price_plan_background_image',
            'home_page_brand_logo_section_status',
            'home_page_latest_news_section_status',
            'home_page_01_contact_area_map_location',
            'get_in_touch_form_fields',
            'home_page_contact_section_status',
        ];
    }

    public function home_01()
    {
        $lang = (new static())->user_lang;
        $list = [
            'home_page_01_' . $lang . '_about_us_title',
            'home_page_01_' . $lang . '_service_area_title',
            'home_page_01_' . $lang . '_service_area_description',
            'home_page_01_' . $lang . '_about_us_video_url',
            'home_page_01_' . $lang . '_latest_news_title',
            'home_page_01_' . $lang . '_latest_news_description',
            'home_page_01_' . $lang . '_latest_news_description',
            'home_page_01_' . $lang . '_contact_area_button_text',
            'home_page_01_' . $lang . '_contact_area_title',
            'home_page_01_' . $lang . '_quality_area_title',
            'home_page_01_' . $lang . '_quality_area_description',
            'home_page_01_' . $lang . '_quality_area_button_status',
            'home_page_01_' . $lang . '_quality_area_button_url',
            'home_page_01_' . $lang . '_quality_area_button_title',
            'home_page_01_' . $lang . '_case_study_title',
            'home_page_01_' . $lang . '_case_study_description',
            'home_page_01_' . $lang . '_read_more_text',
            'home_page_01_' . $lang . '_testimonial_section_title',
            'home_page_01_' . $lang . '_price_plan_section_title',
            'home_page_01_' . $lang . '_price_plan_section_description',
            'case_study_' . $lang . '_read_more_text',

        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_02()
    {
        $lang = $this->user_lang;
        $list = [
            'home_page_key_feature_section_status',
            'home_page_service_section_status',
            'home_page_01_service_area_item_type',
            'home_page_quality_section_status',
            'home_page_02_quality_area_image',
            'home_page_about_us_section_status',
            'home_page_02_about_us_video_background_image',
            'home_page_02_about_us_signature_image',
            'home_page_testimonial_section_status',
            'home_page_brand_logo_section_status',
            'home_page_price_plan_section_status',
            'home_page_counterup_section_status',
            'home_page_case_study_section_status',
            'home_page_02_case_study_background_image',
            'home_page_team_member_section_status',
            'home_page_latest_news_section_status',
            'home_page_01_contact_area_map_location',
            'get_in_touch_form_fields',
            'home_page_01_' . $lang . '_service_area_title',
            'home_page_01_' . $lang . '_service_area_description',
            'home_page_01_' . $lang . '_quality_area_title',
            'home_page_01_' . $lang . '_quality_area_description',
            'home_page_01_' . $lang . '_quality_area_button_status',
            'home_page_01_' . $lang . '_quality_area_button_url',
            'home_page_01_' . $lang . '_quality_area_button_title',
            'home_page_01_' . $lang . '_about_us_video_url',
            'home_page_01_' . $lang . '_about_us_title',
            'home_page_01_' . $lang . '_about_us_description',
            'home_page_01_' . $lang . '_about_us_quote_text',
            'home_page_01_' . $lang . '_testimonial_section_title',
            'home_page_01_' . $lang . '_about_us_quote_text',
            'home_page_01_' . $lang . '_brand_logo_area_title',
            'home_page_01_' . $lang . '_price_plan_section_title',
            'home_page_01_' . $lang . '_price_plan_section_description',
            'home_page_01_' . $lang . '_case_study_title',
            'home_page_01_' . $lang . '_case_study_description',
            'home_page_01_' . $lang . '_team_member_section_title',
            'home_page_01_' . $lang . '_team_member_section_description',
            'home_page_01_' . $lang . '_latest_news_title',
            'home_page_01_' . $lang . '_latest_news_description',
            'home_page_01_' . $lang . '_contact_area_title',
            'home_page_01_' . $lang . '_contact_area_button_text',
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_03()
    {
        $lang = $this->user_lang;
        $list = [
            'home_page_01_contact_area_map_location',
            'get_in_touch_form_fields',
            'home_page_contact_section_status',
            'home_page_about_us_section_status',
            'home_page_03_about_us_image_one',
            'home_page_03_about_us_image_two',
            'home_page_key_feature_section_status',
            'home_page_service_section_status',
            'home_page_01_service_area_background_image',
            'home_page_01_service_area_item_type',
            'home_page_call_to_action_section_status',
            'home_page_01_cta_area_button_url',
            'home_page_case_study_section_status',
            'home_page_testimonial_section_status',
            'home_page_counterup_section_status',
            'home_page_price_plan_section_status',
            'home_page_01_price_plan_background_image',
            'home_page_latest_news_section_status',
            'home_page_brand_logo_section_status',
            'site_' . $lang . '_title',
            'home_page_01_' . $lang . '_contact_area_title',
            'home_page_01_' . $lang . '_contact_area_button_text',
            'home_page_01_' . $lang . '_about_us_title',
            'home_page_01_' . $lang . '_about_us_description',
            'home_page_01_' . $lang . '_about_us_quote_text',
            'home_page_01_' . $lang . '_service_area_title',
            'home_page_01_' . $lang . '_service_area_description',
            'home_page_01_' . $lang . '_cta_area_title',
            'home_page_01_' . $lang . '_cta_area_button_title',
            'home_page_01_' . $lang . '_case_study_title',
            'home_page_01_' . $lang . '_case_study_description',
            'home_page_01_' . $lang . '_price_plan_section_title',
            'home_page_01_' . $lang . '_price_plan_section_description',
            'home_page_01_' . $lang . '_latest_news_title',
            'home_page_01_' . $lang . '_latest_news_description',
            'home_page_01_' . $lang . '_brand_logo_area_title',
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_04()
    {
        $lang = $this->user_lang;
        $list = [
            'home_page_01_contact_area_map_location',
            'get_in_touch_form_fields',
            'home_page_contact_section_status',
            'home_page_about_us_section_status',
            'home_page_04_about_us_our_mission_image',
            'home_page_04_about_us_our_vision_image',
            'home_page_quality_section_status',
            'home_page_04_quality_area_image',
            'home_page_01_en_quality_area_list',
            'home_page_service_section_status',
            'home_page_01_service_area_background_image',
            'home_page_01_service_area_item_type',
            'home_page_case_study_section_status',
            'home_page_testimonial_section_status',
            'home_03_testimonial_bg',
            'home_page_price_plan_section_status',
            'home_page_counterup_section_status',
            'home_page_latest_news_section_status',
            'site_' . $lang . '_title',
            'home_page_01_' . $lang . '_contact_area_title',
            'home_page_01_' . $lang . '_contact_area_button_text',
            'home_page_01_' . $lang . '_about_us_title',
            'home_page_01_' . $lang . '_about_us_description',
            'home_page_01_' . $lang . '_about_us_our_mission_title',
            'home_page_01_' . $lang . '_about_us_our_mission_description',
            'home_page_01_' . $lang . '_about_us_our_vision_title',
            'home_page_01_' . $lang . '_about_us_our_vision_description',
            'home_page_01_' . $lang . '_quality_area_title',
            'home_page_01_' . $lang . '_quality_area_description',
            'home_page_01_' . $lang . '_service_area_title',
            'home_page_01_' . $lang . '_service_area_description',
            'home_page_01_' . $lang . '_case_study_title',
            'home_page_01_' . $lang . '_case_study_description',
            'home_page_01_' . $lang . '_testimonial_section_title',
            'home_page_01_' . $lang . '_price_plan_section_title',
            'home_page_01_' . $lang . '_price_plan_section_description',
            'home_page_01_' . $lang . '_latest_news_title',
            'home_page_01_' . $lang . '_latest_news_description',
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_05()
    {
        $lang = $this->user_lang;
        $list = [
            'home_page_01_contact_area_map_location',
            'get_in_touch_form_fields',
            'home_page_contact_section_status',
            'portfolio_home_page_right_image',
            'portfolio_home_page_button_url',
            'home_page_counterup_section_status',
            'home_page_about_us_section_status',
            'portfolio_about_section_left_image',
            'home_page_05_about_section_icon_box_icon',
            'portfolio_about_section_button_one_url',
            'portfolio_about_section_button_one_icon',
            'portfolio_about_section_button_two_url',
            'portfolio_about_section_button_two_icon',
            'home_page_expertice_section_status',
            'home_page_05_experties_section_skill_box_number',
            'home_page_service_section_status',
            'home_page_case_study_section_status',
            'home_page_call_to_action_section_status',
            'portfolio_cta_section_button_url',
            'portfolio_cta_section_button_icon',
            'portfolio_cta_section_right_image',
            'home_page_testimonial_section_status',
            'home_page_latest_news_section_status',
            'site_' . $lang . '_title',
            'portfolio_home_page_' . $lang . '_subtitle',
            'portfolio_home_page_' . $lang . '_title',
            'portfolio_home_page_' . $lang . '_profession',
            'portfolio_home_page_' . $lang . '_description',
            'portfolio_home_page_' . $lang . '_button_text',
            'portfolio_about_section_' . $lang . '_subtitle',
            'portfolio_about_section_' . $lang . '_title',
            'portfolio_about_section_' . $lang . '_description',
            'home_page_05_' . $lang . '_about_section_icon_box_title',
            'portfolio_about_section_' . $lang . '_button_one_text',
            'portfolio_about_section_' . $lang . '_button_two_text',
            'portfolio_expertice_section_' . $lang . '_subtitle',
            'portfolio_expertice_section_' . $lang . '_title',
            'home_page_05_' . $lang . '_experties_section_skill_box_title',
            'home_page_05_' . $lang . '_experties_section_skill_box_subtitle',
            'home_page_05_' . $lang . '_experties_section_skill_box_subtitle',
            'portfolio_what_we_offer_section_' . $lang . '_subtitle',
            'portfolio_what_we_offer_section_' . $lang . '_title',
            'portfolio_recent_work_section_' . $lang . '_subtitle',
            'portfolio_recent_work_section_' . $lang . '_title',
            'portfolio_recent_work_section_' . $lang . '_button_text',
            'portfolio_cta_section_' . $lang . '_title',
            'portfolio_cta_section_' . $lang . '_description',
            'portfolio_cta_section_' . $lang . '_description',
            'portfolio_cta_section_' . $lang . '_button_text',
            'portfolio_testimonial_section_' . $lang . '_subtitle',
            'portfolio_testimonial_section_' . $lang . '_title',
            'portfolio_news_section_' . $lang . '_subtitle',
            'portfolio_news_section_' . $lang . '_title',
            'portfolio_news_section_' . $lang . '_button_text'
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_06()
    {
        $lang = $this->user_lang;
        $list = [
            'home_page_01_contact_area_map_location',
            'get_in_touch_form_fields',
            'home_page_contact_section_status',
            'home_page_variant',
            'home_page_06_header_section_bg_image',
            'home_page_06_header_section_button_one_url',
            'home_page_06_header_section_button_two_url',
            'home_page_key_feature_section_status',
            'home_page_service_section_status',
            'home_page_video_section_status',
            'portfolio_video_section_background_image',
            'portfolio_video_section_video_url',
            'home_page_counterup_section_status',
            'portfolio_counterup_section_background_image',
            'home_page_case_study_section_status',
            'home_page_quote_faq_section_status',
            'quote_page_form_fields',
            'home_page_testimonial_section_status',
            'home_page_latest_news_section_status',
            'site_' . $lang . '_title',
            'home_page_01_' . $lang . '_contact_area_title',
            'home_page_01_' . $lang . '_contact_area_button_text',
            'home_page_06_' . $lang . '_header_section_description',
            'home_page_06_' . $lang . '_header_section_button_one_text',
            'home_page_06_' . $lang . '_header_section_button_two_text',
            'home_page_06_' . $lang . '_header_section_title',
            'logistic_what_we_offer_section_' . $lang . '_subtitle',
            'logistic_what_we_offer_section_' . $lang . '_title',
            'logistic_what_we_offer_section_' . $lang . '_button_text',
            'logistic_project_section_' . $lang . '_subtitle',
            'logistic_project_section_' . $lang . '_title',
            'logistic_quote_section_' . $lang . '_subtitle',
            'logistic_quote_section_' . $lang . '_title',
            'logistic_quote_section_' . $lang . '_button_text',
            'logistic_faq_section_' . $lang . '_subtitle',
            'logistic_faq_section_' . $lang . '_title',
            'home_page_06_' . $lang . '_faq_item_title',
            'home_page_06_' . $lang . '_faq_item_description',
            'logistic_testimonial_section_' . $lang . '_subtitle',
            'logistic_testimonial_section_' . $lang . '_title',
            'portfolio_news_section_' . $lang . '_button_text',
            'logistic_news_section_' . $lang . '_title',
            'logistic_news_section_' . $lang . '_subtitle',
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_07()
    {
        $lang = $this->user_lang;
        $list = [
            'home_page_01_contact_area_map_location',
            'get_in_touch_form_fields',
            'home_page_contact_section_status',
            'home_page_07_topbar_section_info_item_icon',
            'language_select_option',
            'home_page_07_header_section_bg_image',
            'home_page_07_header_section_button_one_url',
            'home_page_07_header_section_button_one_icon',
            'home_page_about_us_section_status',
            'industry_about_section_left_image',
            'industry_about_section_video_background_image',
            'industry_about_section_video_url',
            'industry_about_section_experience_year',
            'industry_about_section_button_one_url',
            'industry_about_section_button_one_icon',
            'home_page_service_section_status',
            'home_page_counterup_section_status',
            'industry_counterup_section_background_image',
            'home_page_case_study_section_status',
            'home_page_team_member_section_status',
            'home_page_testimonial_section_status',
            'home_page_latest_news_section_status',
            'home_page_brand_logo_section_status',
            'site_'.$lang.'_title',
            'home_page_01_'.$lang.'_contact_area_title',
            'home_page_01_'.$lang.'_contact_area_button_text',
            'home_page_07_'.$lang.'_topbar_section_info_item_title',
            'home_page_07_'.$lang.'_topbar_section_info_item_details',
            'home_page_07_'.$lang.'_header_section_description',
            'home_page_07_'.$lang.'_header_section_button_one_text',
            'home_page_07_'.$lang.'_header_section_title',
            'industry_about_section_'.$lang.'_experience_year_title',
            'industry_about_section_'.$lang.'_title',
            'industry_about_section_'.$lang.'_subtitle',
            'industry_about_section_'.$lang.'_description',
            'industry_about_section_'.$lang.'_button_one_text',
            'industry_what_we_offer_section_'.$lang.'_subtitle',
            'industry_what_we_offer_section_'.$lang.'_title',
            'industry_what_we_offer_section_'.$lang.'_readmore_text',
            'logistic_what_we_offer_section_'.$lang.'_button_text',
            'industry_project_section_'.$lang.'_subtitle',
            'industry_project_section_'.$lang.'_title',
            'industry_team_member_section_'.$lang.'_subtitle',
            'industry_team_member_section_'.$lang.'_title',
            'industry_testimonial_section_'.$lang.'_subtitle',
            'industry_testimonial_section_'.$lang.'_title',
            'industry_news_area_section_'.$lang.'_subtitle',
            'industry_news_area_section_'.$lang.'_title',
            'portfolio_news_section_'.$lang.'_button_text',
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_08()
    {
        $lang = $this->user_lang;
        $list = [
            'creative_agency_video_section_video_url',
            'home_page_variant',
            'site_white_logo',
            'product_module_status',
            'home_page_01_contact_area_map_location',
            'get_in_touch_form_fields',
            'home_page_contact_section_status',
            'cagency_header_section_right_image',
            'cagency_header_section_button_one_url',
            'cagency_header_section_button_one_icon',
            'home_page_service_section_status',
            'home_page_video_section_status',
            'creative_agency_video_section_background_image',
            'creative_agency_video_section_background_image',
            'home_page_counterup_section_status',
            'home_page_case_study_section_status',
            'cagency_work_process_section_item_number',
            'home_page_call_to_action_section_status',
            'cagency_cta_section_right_image',
            'cagency_cta_section_button_url',
            'cagency_cta_section_button_icon',
            'home_page_testimonial_section_status',
            'home_page_latest_news_section_status',
            'site_'.$lang.'_title',
            'home_page_01_'.$lang.'_contact_area_title',
            'home_page_01_'.$lang.'_contact_area_button_text',
            'cagency_header_section_'.$lang.'_title',
            'cagency_header_section_'.$lang.'_description',
            'cagency_header_section_'.$lang.'_button_one_text',
            'cagency_what_we_offer_section_'.$lang.'_subtitle',
            'cagency_what_we_offer_section_'.$lang.'_title',
            'logistic_what_we_offer_section_'.$lang.'_button_text',
            'cagency_work_process_section_'.$lang.'_subtitle',
            'cagency_work_process_section_'.$lang.'_title',
            'cagency_work_process_section_item_'.$lang.'_title',
            'cagency_our_portfolio_section_'.$lang.'_subtitle',
            'cagency_our_portfolio_section_'.$lang.'_title',
            'cagency_cta_section_'.$lang.'_title',
            'cagency_cta_section_'.$lang.'_description',
            'cagency_cta_section_'.$lang.'_button_text',
            'cagency_testimonial_section_'.$lang.'_subtitle',
            'cagency_testimonial_section_'.$lang.'_title',
            'cagency_news_area_section_'.$lang.'_subtitle',
            'cagency_news_area_section_'.$lang.'_title',
            'portfolio_news_section_'.$lang.'_button_text',
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_10()
    {
        $lang = $this->user_lang;
        $list = [
            'home_page_about_us_section_status',
            'home_page_service_section_status',
            'home_page_case_study_section_status',
            'home_page_team_member_section_status',
            'home_page_counterup_section_status',
            'home_page_testimonial_section_status',
            'home_page_latest_news_section_status',
            'home_page_contact_section_status',
            'home_page_call_to_action_section_status',
            'get_in_touch_form_fields',
            'home_page_01_service_area_items',
            'product_module_status',
            'home_page_10_header_section_bg_image',
            'home_page_10_header_section_button_one_url',
            'home_page_10_header_section_button_two_url',
            'home_page_10_key_features_section_icon',
            'lawyer_about_section_button_url',
            'lawyer_about_section_left_top_image',
            'lawyer_about_section_left_bottom_image',
            'home_10_counterup_section_background_image',
            'home_page_10_cta_area_background_image',
            'home_page_10_cta_area_button_url',
            'home_page_10_'.$lang.'_header_section_description',
            'home_page_10_'.$lang.'_header_section_button_one_text',
            'home_page_10_'.$lang.'_header_section_button_two_text',
            'home_page_10_'.$lang.'_header_section_title',
            'home_page_10_'.$lang.'_header_section_subtitle',
            'home_page_10_'.$lang.'_key_feeatures_item_description',
            'home_page_10_'.$lang.'_key_features_item_title',
            'lawyer_about_section_'.$lang.'_subtitle',
            'lawyer_about_section_'.$lang.'_title',
            'lawyer_about_section_'.$lang.'_description',
            'lawyer_about_section_'.$lang.'_button_text',
            'home_page_10_'.$lang.'_service_area_title',
            'home_page_10_'.$lang.'_service_area_subtitle',
            'home_page_10_'.$lang.'_service_area_readmore_text',
            'home_page_10_'.$lang.'_team_member_section_subtitle',
            'home_page_10_'.$lang.'_team_member_section_title',
            'home_page_10_'.$lang.'_testimonial_section_title',
            'home_page_10_'.$lang.'_testimonial_section_subtitle',
            'home_page_10_'.$lang.'_new_area_subtitle',
            'home_page_10_'.$lang.'_new_area_title',
            'home_page_10_'.$lang.'_cta_area_title',
            'home_page_10_'.$lang.'_cta_area_description',
            'home_page_10_'.$lang.'_cta_area_button_status',
            'home_page_10_'.$lang.'_cta_area_button_title',
            'home_page_10_'.$lang.'_contact_area_title',
            'home_page_10_'.$lang.'_contact_area_button_title',
            'home_page_appointment_section_status',
            'home_page_10_'.$lang.'_appointment_section_subtitle',
            'home_page_10_'.$lang.'_appointment_section_title',
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_11()
    {
        $lang = $this->user_lang;
        $list = [
            'home_page_about_us_section_status',
            'home_page_key_feature_section_status',
            'home_page_counterup_section_status',
            'home_page_video_section_status',
            'home_page_call_to_action_section_status',
            'home_page_testimonial_section_status',
            'home_page_latest_news_section_status',
            'home_page_service_section_status',
            'home_page_11_key_features_section_icon',
            'political_home_page_header_'.$lang.'_title',
            'political_home_page_header_'.$lang.'_description',
            'political_home_page_header_'.$lang.'_button_text',
            'home_page_11_'.$lang.'_key_features_item_title',
            'political_home_page_header_button_url' ,
            'political_home_page_header_left_image',
            'political_home_page_header_background_image',
            'political_about_section_button_url',
            'political_about_section_right_image',
            'political_about_section_'.$lang.'_subtitle',
            'political_about_section_'.$lang.'_title',
            'political_about_section_'.$lang.'_description',
            'political_about_section_'.$lang.'_button_text',
            'home_page_11_video_area_video_url',
            'home_page_11_video_area_background_image',
            'home_page_11_cta_area_button_url',
            'home_11_counterup_section_background_image',
            'home_page_11_cta_area_background_image',
            'home_page_01_event_area_items',
            'home_page_11_'.$lang.'_cta_area_subtitle',
            'home_page_11_'.$lang.'_cta_area_title',
            'home_page_11_'.$lang.'_cta_area_description',
            'home_page_11_'.$lang.'_cta_area_button_status',
            'home_page_11_'.$lang.'_cta_area_button_title',
            'home_page_11_'.$lang.'_service_area_subtitle',
            'home_page_11_'.$lang.'_service_area_title',
            'home_page_11_'.$lang.'_service_area_readmore_text',
            'home_page_11_'.$lang.'_event_area_subtitle',
            'home_page_11_'.$lang.'_event_area_title',
            'home_page_11_testimonial_area_background_image',
            'home_page_11_'.$lang.'_testimonial_section_subtitle',
            'home_page_11_'.$lang.'_testimonial_section_title',
            'home_page_11_'.$lang.'_new_area_subtitle',
            'home_page_11_'.$lang.'_new_area_title',
            'home_page_11_'.$lang.'_new_area_button_text',
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_12()
    {
        $lang = $this->user_lang;
        $list = [
            'home_page_about_us_section_status',
            'home_page_call_to_action_section_status',
            'home_page_service_section_status',
            'medical_home_page_header_button_two_url' ,
            'medical_home_page_header_button_url' ,
            'medical_home_page_header_right_image',
            'medical_home_page_header_background_image',
            'medical_about_section_button_url',
            'medical_about_section_right_image',
            'medical_about_section_right_bottom_image',
            'medical_home_page_header_'.$lang.'_title',
            'medical_home_page_header_'.$lang.'_description',
            'medical_home_page_header_'.$lang.'_button_text',
            'medical_home_page_header_'.$lang.'_button_two_text',
            'medical_about_section_'.$lang.'_subtitle',
            'medical_about_section_'.$lang.'_title',
            'medical_about_section_'.$lang.'_description',
            'medical_about_section_'.$lang.'_button_text',
            'home_page_12_'.$lang.'_service_area_subtitle',
            'home_page_12_'.$lang.'_service_area_title',
            'home_page_counterup_section_status',
            'appointment_form_fields',
            'home_page_team_member_section_status',
            'home_page_case_study_section_status',
            'home_page_testimonial_section_status',
            'home_page_latest_news_section_status',
            'home_page_brand_logo_section_status',
            'medical_appointment_section_'.$lang.'_subtitle',
            'medical_appointment_section_'.$lang.'_title',
            'medical_appointment_section_'.$lang.'_description',
            'medical_appointment_section_'.$lang.'_hotline',
            'medical_appointment_section_'.$lang.'_button_text',
            'home_page_11_'.$lang.'_team_member_section_title',
            'home_page_11_'.$lang.'_team_member_section_subtitle',
            'home_page_12_'.$lang.'_case_study_section_title',
            'home_page_12_'.$lang.'_case_study_section_subtitle',
            'home_page_12_'.$lang.'_testimonial_section_title',
            'home_page_12_'.$lang.'_testimonial_section_subtitle',
            'home_page_12_'.$lang.'_news_section_subtitle',
            'home_page_12_'.$lang.'_news_section_title',
            'home_page_12_'.$lang.'_news_section_readmore_text',
            'home_page_12_about_section_video_url',
            'medical_cta_area_section_'.$lang.'_subtitle',
            'medical_cta_area_section_'.$lang.'_title',
            'medical_cta_area_section_'.$lang.'_description',
            'medical_cta_area_section_'.$lang.'_hotline',
            'medical_cta_area_section_'.$lang.'_button_text',
            'home_page_12_'.$lang.'_appointment_section_subtitle',
            'home_page_12_'.$lang.'_appointment_section_title',
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_13()
    {
        $lang = $this->user_lang;
        $list = [
            'home_page_about_us_section_status',
            'home_page_13_'.$lang.'_header_section_subtitle',
            'home_page_13_'.$lang.'_header_section_title' ,
            'home_page_13_'.$lang.'_header_section_description',
            'home_page_13_'.$lang.'_header_section_button_one_text',
            'home_page_13_header_section_button_one_url' ,
            'home_page_13_header_section_button_one_icon',
            'home_page_13_header_section_bg_image',
            'home_page_13_about_section_button_url',
            'home_page_13_about_section_video_url',
            'home_page_13_about_section_right_image',
            'home_page_13_about_section_button_icon',
            'home_page_donation_cause_section_status',
            'home_page_call_to_action_section_status',
            'home_page_team_member_section_status',
            'home_page_13_popular_cause_popular_cause_background_image',
            'home_page_13_'.$lang.'_about_section_subtitle',
            'home_page_13_'.$lang.'_about_section_title',
            'home_page_13_'.$lang.'_about_section_description',
            'home_page_13_'.$lang.'_about_section_button_text',
            'home_page_13_'.$lang.'_popular_cause_subtitle',
            'home_page_13_'.$lang.'_popular_cause_title',
            'home_page_13_'.$lang.'_popular_cause_goal_text',
            'home_page_13_'.$lang.'_popular_cause_rise_text',
            'home_page_13_'.$lang.'_team_member_section_title',
            'home_page_13_'.$lang.'_team_member_section_subtitle',
            'home_page_13_'.$lang.'_cta_area_title',
            'home_page_13_'.$lang.'_cta_area_button_title',
            'home_page_13_'.$lang.'_cta_area_button_status',
            'home_page_13_cta_area_button_url',
            'home_page_13_cta_area_background_image',
            'home_page_13_cta_section_button_icon',
            'home_page_event_section_status',
            'home_page_01_event_area_items',
            'home_page_testimonial_section_status',
            'home_page_latest_news_section_status',
            'home_page_brand_logo_section_status',
            'home_page_13_testimonial_section_background_image',
            'home_page_13_'.$lang.'_event_area_subtitle',
            'home_page_13_'.$lang.'_event_area_title',
            'home_page_13_'.$lang.'_testimonial_section_subtitle',
            'home_page_13_'.$lang.'_testimonial_section_title',
            'home_page_13_'.$lang.'_cta_two_area_title',
            'home_page_13_'.$lang.'_cta_two_area_button_title',
            'home_page_13_'.$lang.'_cta_two_area_button_status',
            'home_page_13_cta_two_section_button_icon',
            'home_page_13_cta_two_area_button_url',
            'home_page_13_'.$lang.'_new_area_subtitle',
            'home_page_13_'.$lang.'_new_area_title',
            'home_page_13_'.$lang.'_new_area_button_text'
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_14()
    {
        $lang = $this->user_lang;
        $list = [
            'home_page_call_to_action_section_status',
            'home_page_service_section_status',
            'home_page_brand_logo_section_status',
            'home_page_case_study_section_status',
            'home_page_work_process_section_status',
            'home_page_counterup_section_status',
            'home_page_14_counterup_section_background_image',
            'home_page_latest_news_section_status',
            'home_page_testimonial_section_status',
            'home_page_contact_section_status',
            'get_in_touch_form_fields',
            'home_page_14_header_background_image',
            'home_page_14_header_right_image',
            'home_page_14_'.$lang.'_header_area_button_one_icon',
            'home_page_14_'.$lang.'_header_area_button_one_url',
            'home_page_14_'.$lang.'_header_area_title',
            'home_page_14_'.$lang.'_header_area_description',
            'home_page_14_'.$lang.'_header_area_button_one_text',
            'home_page_14_'.$lang.'_service_area_subtitle',
            'home_page_14_'.$lang.'_service_area_title',
            'home_page_14_'.$lang.'_project_area_title',
            'home_page_14_'.$lang.'_project_area_subtitle',
            'home_page_14_cta_section_button_icon',
            'home_page_14_cta_area_button_url',
            'home_page_14_cta_area_right_image',
            'home_page_14_'.$lang.'_cta_area_button_title',
            'home_page_14_'.$lang.'_cta_area_button_status',
            'home_page_14_'.$lang.'_cta_area_description',
            'home_page_14_'.$lang.'_cta_area_title',
            'home_page_14_work_process_section_'.$lang.'_subtitle',
            'home_page_14_work_process_section_'.$lang.'_title',
            'home_page_14_work_process_section_item_'.$lang.'_title',
            'home_page_14_work_process_section_item_number',
            'home_page_14_'.$lang.'_testimonial_section_subtitle',
            'home_page_14_'.$lang.'_testimonial_section_title',
            'home_page_14_'.$lang.'_news_area_section_subtitle',
            'home_page_14_'.$lang.'_news_area_section_title',
            'home_page_14_'.$lang.'_contact_area_subtitle',
            'home_page_14_'.$lang.'_contact_area_title',
            'home_page_14_'.$lang.'_contact_area_button_text',
            'home_page_14_contact_area_button_icon',
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_15()
    {
        $lang = $this->user_lang;
        $list = [
            'home_page_15_'.$lang.'_header_area_title',
            'home_page_15_'.$lang.'_header_area_description',
            'home_page_15_'.$lang.'_header_area_button_text',
            'home_page_15_header_area_button_url',
            'home_page_15_header_area_button_icon',
            'home_page_15_header_area_background_image',
            'home_page_15_header_area_bottom_image',
            'home_page_15_'.$lang.'_offer_item_title',
            'home_page_15_'.$lang.'_offer_item_short_description',
            'home_page_15_'.$lang.'_offer_item_button_text',
            'home_page_15_offer_item_button_url',
            'home_page_15_offer_item_image',
            'home_page_15_'.$lang.'_featured_product_area_subtitle',
            'home_page_15_'.$lang.'_featured_product_area_title',
            'home_page_15_'.$lang.'_featured_product_area_items',
            'home_page_15_process_area_background_image',
            'home_page_15_process_area_right_image',
            'home_page_15_process_area_left_image',
            'home_page_15_'.$lang.'_process_area_item_title',
            'home_page_15_'.$lang.'_process_area_item_description',
            'home_page_15_process_area_item_icon',
            'home_page_15_process_area_item_number',
            'home_page_15_'.$lang.'_product_section_subtitle',
            'home_page_15_'.$lang.'_product_section_title',
            'home_page_products_area_items',
            'home_page_testimonial_section_status',
            'home_page_15_'.$lang.'_testimonial_area_title',
            'home_page_15_'.$lang.'_testimonial_area_subtitle',
            'home_page_15_testimonial_area_background_image',
            'home_page_15_testimonial_area_right_image',
            'home_page_15_testimonial_area_left_image',
            'home_page_15_top_selling_product_area_items',
            'home_page_15_top_selling_product_area_left_image',
            'home_page_15_top_selling_product_area_right_image',
            'home_page_15_'.$lang.'_top_selling_product_area_title',
            'home_page_15_'.$lang.'_top_selling_product_area_subtitle',
            'home_page_brand_logo_section_status',
            'home_page_top_selling_section_status',
            'home_page_online_store_section_status',
            'home_page_process_section_status',
            'home_page_offer_section_status',
            'home_page_featured_fruit_section_status',
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_16()
    {
        $lang = $this->user_lang;
        $list = [
            'home_page_16_header_area_button_url',
            'home_page_16_header_area_background_image',
            'home_page_16_header_area_right_image',
            'home_page_16_'.$lang.'_header_area_title',
            'home_page_16_'.$lang.'_header_area_description',
            'home_page_16_'.$lang.'_header_area_button_text',
            'home_page_about_us_section_status',
            'home_page_16_'.$lang.'_about_section_button_text',
            'home_page_16_'.$lang.'_about_section_description',
            'home_page_16_'.$lang.'_about_section_title',
            'home_page_16_'.$lang.'_about_section_subtitle',
            'home_page_16_about_section_left_image',
            'home_page_16_about_section_button_url',
            'home_page_16_'.$lang.'_service_area_title',
            'home_page_16_'.$lang.'_service_area_subtitle',
            'home_page_01_service_area_items',
            'home_page_service_section_status',
            'home_page_16_'.$lang.'_estimate_area_form_button_text',
            'home_page_16_'.$lang.'_estimate_area_form_title',
            'home_page_16_'.$lang.'_estimate_area_title',
            'home_page_brand_logo_section_status',
            'estimate_form_fields',
            'home_page_case_study_section_status',
            'home_page_latest_news_section_status',
            'home_page_counterup_section_status',
            'home_page_testimonial_section_status',
            'home_page_16_'.$lang.'_work_section_title',
            'home_page_16_'.$lang.'_work_section_subtitle',
            'home_page_16_'.$lang.'_testimonial_area_subtitle',
            'home_page_16_'.$lang.'_testimonial_area_title',
            'home_page_16_'.$lang.'_new_area_subtitle',
            'home_page_16_'.$lang.'_new_area_title',
            'home_page_16_'.$lang.'_new_area_button_text',
            'home_page_quote_faq_section_status',
            'home_page_appointment_section_status',
            'home_page_16_'.$lang.'_appointment_section_subtitle',
            'home_page_16_'.$lang.'_appointment_section_title',
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_17()
    {
        $lang = $this->user_lang;
        $list = [
            'home_page_17_header_area_button_url',
            'home_page_17_header_area_button_icon',
            'home_page_17_header_area_background_image',
            'home_page_17_header_area_right_image',
            'home_page_17_'.$lang.'_header_area_title',
            'home_page_17_'.$lang.'_header_area_description',
            'home_page_17_'.$lang.'_header_area_button_text',
            'course_home_page_'.$lang.'_specialities_area_title',
            'course_home_page_specialities_item_icon',
            'course_home_page_specialities_item_icon',
            'course_home_page_'.$lang.'_specialities_item_title',
            'course_home_page_'.$lang.'_specialities_item_description',
            'course_home_page_specialities_item_url',
            'course_home_page_'.$lang.'_featured_course_area_title',
            'home_page_testimonial_section_status',
            'home_page_video_section_status',
            'home_page_counterup_section_status',
            'course_home_page_video_section_background_image',
            'course_home_page_video_section_video_url',
            'course_home_page_'.$lang.'_all_course_area_title',
            'course_home_page_'.$lang.'_all_course_area_button_text',
            'course_home_page_'.$lang.'_testimonial_area_title',
            'home_page_event_section_status',
            'course_home_page_'.$lang.'_event_area_title',
            'home_page_call_to_action_section_status',
            'course_home_page_cta_section_button_icon',
            'course_home_page_cta_area_button_url',
            'course_home_page_'.$lang.'_cta_area_title',
            'course_home_page_'.$lang.'_cta_area_button_status',
            'course_home_page_'.$lang.'_cta_area_button_title',
            'home_page_all_courses_section_status',
            'home_page_featured_courses_section_status',
            'home_page_course_category_section_status',
            'home_page_our_speciality_section_status',
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_18()
    {
        $lang = $this->user_lang;
        $list = [
            'product_module_status',
            'home_page_17_header_area_button_url',
            'home_page_17_header_area_button_icon',
            'home_page_17_header_area_background_image',
            'home_page_17_header_area_right_image',
            'grocery_home_page_'.$lang.'_header_section_subtitle',
            'grocery_home_page_'.$lang.'_header_section_title' ,
            'grocery_home_page_'.$lang.'_header_section_description',
            'grocery_home_page_'.$lang.'_header_section_button_one_text',
            'grocery_home_page_header_section_button_one_url' ,
            'grocery_home_page_header_section_button_one_icon',
            'grocery_home_page_header_section_bg_image',
            'grocery_home_page_'.$lang.'_product_category_area_title',
            'home_page_offer_section_status',
            'home_page_featured_fruit_section_status',
            'grocery_home_page_'.$lang.'_featured_product_area_subtitle',
            'grocery_home_page_'.$lang.'_featured_product_area_title',
            'home_page_process_section_status',
            'grocery_home_page_process_area_background_image',
            'grocery_home_page_process_area_right_image',
            'grocery_home_page_process_area_left_image',
            'grocery_home_page_'.$lang.'_process_area_item_title',
            'grocery_home_page_'.$lang.'_process_area_item_description',
            'grocery_home_page_process_area_item_icon',
            'grocery_home_page_process_area_item_number',
            'home_page_online_store_section_status',
            'home_page_brand_logo_section_status',
            'home_page_testimonial_section_status',
            'home_page_product_category_section_status',
            'grocery_home_page_'.$lang.'_product_section_subtitle',
            'grocery_home_page_'.$lang.'_product_section_title',
            'grocery_home_page_'.$lang.'_product_section_button_text',
            'grocery_home_page_'.$lang.'_testimonial_area_title',
            'grocery_home_page_'.$lang.'_testimonial_area_subtitle'
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_19()
    {
        $lang = $this->user_lang;
        $list = [
            'product_module_status',
            'home19_clothing_area_section_'.$lang.'_title',
            'home19_clothing_area_section_'.$lang.'_subtitle',
            'home19_clothing_area_section_'.$lang.'_button_text',
            'home19_clothing_area_section_'.$lang.'_button_url',
            'home19_clothing_area_section_left_image',
            'home19_clothing_area_section_right_image',
            'home_page_19_'.$lang.'_popular_area_title',
            'home_page_19_'.$lang.'_popular_area_products',
            'home_page_19_'.$lang.'_instagram_area_title'
        ];
        return array_merge(self::default_settings(), $list);
    }

    public function home_09()
    {
        $lang = (new static())->user_lang;
        $list = [
            'home_page_07_topbar_section_info_item_icon',
            'home_page_07_' . $lang . '_topbar_section_info_item_title',
            'home_page_07_' . $lang . '_topbar_section_info_item_details',
            'language_select_option',
            'navbar_button',
            'navbar_button_custom_url_status',
            'navbar_' . $lang . '_button_text',
            'site_white_logo',
            'site_' . $lang . '_title',
            'product_module_status',
            'construction_header_section_bg_image',
            'construction_header_section_' . $lang . '_title',
            'construction_header_section_' . $lang . '_description',
            'construction_header_section_' . $lang . '_button_one_text',
            'construction_header_section_button_one_icon',
            'construction_header_section_button_one_url',
            'home_page_about_us_section_status',
            'construction_about_section_left_image',
            'construction_about_section_video_url',
            'construction_about_section_experience_year',
            'construction_about_section_' . $lang . '_experience_year_title',
            'construction_about_section_' . $lang . '_subtitle',
            'construction_about_section_' . $lang . '_title',
            'construction_about_section_' . $lang . '_description',
            'construction_about_section_' . $lang . '_button_one_text',
            'construction_about_section_button_one_icon',
            'construction_about_section_button_one_url',
            'home_page_counterup_section_status',
            'home_page_service_section_status',
            'construction_what_we_offer_section_' . $lang . '_subtitle',
            'construction_what_we_offer_section_' . $lang . '_title',
            'construction_what_we_offer_section_' . $lang . '_button_text',
            'home_page_quote_faq_section_status',
            'construction_quote_section_bg_image',
            'construction_quote_section_right_image',
            'construction_quote_section_' . $lang . '_subtitle',
            'construction_quote_section_' . $lang . '_title',
            'construction_quote_section_' . $lang . '_button_text',
            'construction_quote_section__button_icon',
            'quote_page_form_fields',
            'home_page_case_study_section_status',
            'construction_project_section_' . $lang . '_subtitle',
            'construction_project_section_' . $lang . '_title',
            'home_page_team_member_section_status',
            'construction_team_member_section_' . $lang . '_subtitle',
            'construction_team_member_section_' . $lang . '_title',
            'home_page_testimonial_section_status',
            'construction_testimonial_section_' . $lang . '_subtitle',
            'construction_testimonial_section_' . $lang . '_title',
            'home_page_latest_news_section_status',
            'construction_news_area_section_' . $lang . '_title',
            'construction_news_area_section_' . $lang . '_subtitle',
            'portfolio_news_section_' . $lang . '_button_text',
        ];
        return array_merge(self::default_settings(), $list);
    }
    public function home_21()
    {
        $lang = (new static())->user_lang;
        $list = [
            'home_page_07_topbar_section_info_item_icon',
            'home_page_07_' . $lang . '_topbar_section_info_item_title',
            'home_page_07_' . $lang . '_topbar_section_info_item_details',
            'language_select_option',
            'navbar_button',
            'navbar_button_custom_url_status',
            'navbar_' . $lang . '_button_text',
            'site_white_logo',
            'site_' . $lang . '_title',
            'product_module_status',
            'home_page_about_us_section_status',
            'construction_about_section_left_image',
            'construction_about_section_video_url',
            'construction_about_section_experience_year',
            'home_page_counterup_section_status',
            'home_page_service_section_status',
            'home_page_quote_faq_section_status',
            'home_page_case_study_section_status',
            'home_page_team_member_section_status',
            'home_page_testimonial_section_status',
            'home_page_latest_news_section_status',
            //header area
            'home21_header_section_background_image',
            'home21_header_section_right_image',
            'home21_header_section_text_image',
            'home21_header_section_title_shape_image',
            'home21_header_section_shape_01_image',
            'home21_header_section_shape_02_image',
            'home21_header_section_shape_03_image',
            'home21_header_section_button_one_url',
            'home21_header_section_button_two_url',

            'home_21_header_section_'.$lang.'_title',
            'home_21_header_section_'.$lang.'_description',
            'home_21_header_section_'.$lang.'_button_one_text',
            'home_21_header_section_'.$lang.'_button_two_text',
            'home_21_header_section_'.$lang.'_button_two_info_text',
            //header social
            'home_21_header_section_'.$lang.'_social_text',
            'home21_header_section_social_url',

            //services section
            'home_21_service_section_button_one_url',
            'home_21_service_section_items',
            'home21_services_section_right_shape_image',
            'home21_services_section_left_shape_image',
            'home_21_service_section_'.$lang.'_button_one_text',
            'home_21_service_section_'.$lang.'_item_explore_one_text',
            'home_21_service_section_'.$lang.'_description',
            'home_21_service_section_'.$lang.'_title',
            'home_21_service_section_'.$lang.'_subtitle',
            //project area
            'home_21_project_section_'.$lang.'_item_explore_one_text',
            'home_21_project_section_'.$lang.'_title',
            'home_21_project_section_'.$lang.'_subtitle',
            //counterup area
            'home_21_counterup_section_'.$lang.'_description',
            'home_21_counterup_section_'.$lang.'_title',
            //blog
            'home_21_blog_section_'.$lang.'_item_keep_reading_text',
            'home_21_blog_section_'.$lang.'_subtitle',
            'home_21_blog_section_'.$lang.'_title',
            // testimonial
            'home_21_testimonial_section_'.$lang.'_subtitle',
            'home_21_testimonial_section_'.$lang.'_title',
            //contact
            'home_21_contact_section_'.$lang.'_info_item_details',
            'home_21_contact_section_'.$lang.'_info_item_title',
            'home21_contact_section_info_item_icon',
            'home_21_contact_section_'.$lang.'_title',
            'home_21_contact_section_'.$lang.'_button_text',
            //newsletter
            'home_21_newsletter_section_'.$lang.'_title',
            'home_21_newsletter_section_'.$lang.'_subtitle',
            'home_21_newsletter_section_'.$lang.'_placeholder_text',
            'home_21_newsletter_section_shape_image',
        ];
        return array_merge(self::default_settings(), $list);
    }
    public function home_20()
    {
        $lang = (new static())->user_lang;
        $list = [
            'home_page_07_topbar_section_info_item_icon',
            'home_page_07_' . $lang . '_topbar_section_info_item_title',
            'home_page_07_' . $lang . '_topbar_section_info_item_details',
            'language_select_option',
            'navbar_button',
            'navbar_button_custom_url_status',
            'navbar_' . $lang . '_button_text',
            'site_white_logo',
            'site_' . $lang . '_title',
            'product_module_status',
            'home_page_about_us_section_status',
            'construction_about_section_left_image',
            'construction_about_section_video_url',
            'construction_about_section_experience_year',
            'home_page_counterup_section_status',
            'home_page_service_section_status',
            'home_page_quote_faq_section_status',
            'home_page_case_study_section_status',
            'home_page_team_member_section_status',
            'home_page_testimonial_section_status',
            'home_page_latest_news_section_status',
            //header area
            'home_20_breaking_news_section_'.$lang.'_title',
            'home_20_header_section_'.$lang.'_readmore_text',
            'home20_popular_news_section_'.$lang.'_section_title',
            'home20_video_news_section_'.$lang.'_section_title',
            'home20_video_news_section_items',
            'home20_sports_news_section_'.$lang.'_section_title',
            'home20_hot_news_section_'.$lang.'_section_title',
        ];
        return array_merge(self::default_settings(), $list);
    }

    public static function get_home_field($homepage_id)
    {
        $new_self = new self();
        $home_var = 'home_' . $homepage_id;
        if(method_exists($new_self,$home_var)){
            return $new_self->$home_var();
        }
        return self::default_settings();
    }
}