@extends('backend.admin-master')
@section('style')
    <link rel="stylesheet" href="{{asset('assets/backend/css/dropzone.css')}}">
    <link rel="stylesheet" href="{{asset('assets/backend/css/media-uploader.css')}}">
    <link rel="stylesheet" href="{{asset('assets/backend/css/summernote-bs4.css')}}">
@endsection
@section('site-title')
    {{__('Header Area')}}
@endsection
@section('content')
    <div class="col-lg-12 col-ml-12 padding-bottom-30">
        <div class="row">
            <div class="col-lg-12">
                <div class="margin-top-40"></div>
                @include('backend/partials/message')
                @include('backend/partials/error')
            </div>
            <div class="col-lg-12 mt-t">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title">{{__('Header Area Settings')}}</h4>

                        <form action="{{route('admin.home21.header')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <nav>
                                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                    @foreach($all_languages as $key => $lang)
                                        <a class="nav-item nav-link @if($key == 0) active @endif" id="nav-home-tab" data-toggle="tab" href="#nav-home-{{$lang->slug}}" role="tab" aria-controls="nav-home" aria-selected="true">{{$lang->name}}</a>
                                    @endforeach
                                </div>
                            </nav>
                            <div class="tab-content margin-top-30" id="nav-tabContent">
                                @foreach($all_languages as $key => $lang)
                                    <div class="tab-pane fade @if($key == 0) show active @endif" id="nav-home-{{$lang->slug}}" role="tabpanel" aria-labelledby="nav-home-tab">
                                        <div class="form-group">
                                            <label for="home_21_header_section_{{$lang}}_title">{{__('Title')}}</label>
                                            <input type="text" name="home_21_header_section_{{$lang->slug}}_title" value="{{get_static_option('home_21_header_section_'.$lang->slug.'_title')}}" class="form-control" >
                                            <small class="info-text">{{__('use {shape}text{/shape} to show shape in the title')}}</small>
                                        </div>
                                        <div class="form-group">
                                            <label for="home_21_header_section_{{$lang->slug}}_description">{{__('Description')}}</label>
                                            <textarea name="home_21_header_section_{{$lang->slug}}_description" class="summernote form-control" cols="30" rows="10">{{get_static_option('home_21_header_section_'.$lang->slug.'_description')}}</textarea>
                                        </div>
                                        <div class="form-group">
                                            <label for="home_21_header_section_{{$lang}}_button_one_text">{{__('Button One Text')}}</label>
                                            <input type="text" name="home_21_header_section_{{$lang->slug}}_button_one_text" value="{{get_static_option('home_21_header_section_'.$lang->slug.'_button_one_text')}}" class="form-control" >
                                        </div>
                                        <div class="form-group">
                                            <label for="home_21_header_section_{{$lang}}_button_two_text">{{__('Button Two Text')}}</label>
                                            <input type="text" name="home_21_header_section_{{$lang->slug}}_button_two_text" value="{{get_static_option('home_21_header_section_'.$lang->slug.'_button_two_text')}}" class="form-control" >
                                        </div>
                                        <div class="form-group">
                                            <label for="home_21_header_section_{{$lang}}_button_two_text">{{__('Button Two Info Text')}}</label>
                                            <input type="text" name="home_21_header_section_{{$lang->slug}}_button_two_info_text" value="{{get_static_option('home_21_header_section_'.$lang->slug.'_button_two_info_text')}}" class="form-control" >
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="form-group">
                                <label for="home21_header_section_button_one_url">{{__('Button One URL')}}</label>
                                <input type="text" name="home21_header_section_button_one_url" value="{{get_static_option('home21_header_section_button_one_url')}}" class="form-control" >
                            </div>
                            <div class="form-group">
                                <label for="home21_header_section_button_two_url">{{__('Button Two URL')}}</label>
                                <input type="text" name="home21_header_section_button_two_url" value="{{get_static_option('home21_header_section_button_two_url')}}" class="form-control" >
                            </div>
                            @php
                                $all_icon_fields =  get_static_option('home21_header_section_social_url');
                                $all_icon_fields = !empty($all_icon_fields) ? unserialize($all_icon_fields,['class' => false]) : ['#'];
                            @endphp
                            @foreach($all_icon_fields as $index => $icon_field)
                                <div class="iconbox-repeater-wrapper">
                                    <div class="all-field-wrap">
                                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                                            @foreach($all_languages as $key => $lang)
                                                <li class="nav-item">
                                                    <a class="nav-link @if($key == 0) active @endif" data-toggle="tab" href="#tab_{{$lang->slug}}_{{$key + $index}}" role="tab"  aria-selected="true">{{$lang->name}}</a>
                                                </li>
                                            @endforeach
                                        </ul>
                                        <div class="tab-content margin-top-30" id="myTabContent">
                                            @foreach($all_languages as $key => $lang)
                                                @php
                                                    $all_title_fields = get_static_option('home_21_header_section_'.$lang->slug.'_social_text');
                                                    $all_title_fields = !empty($all_title_fields) ? unserialize($all_title_fields,['class' => false]) : [];
                                                @endphp

                                                <div class="tab-pane fade @if($key == 0) show active @endif" id="tab_{{$lang->slug}}_{{$key + $index}}" role="tabpanel" >
                                                    <div class="form-group">
                                                        <label for="home_21_header_section_{{$lang->slug}}_social_text">{{__('Text')}}</label>
                                                        <input type="text" name="home_21_header_section_{{$lang->slug}}_social_text[]" class="form-control" value="{{$all_title_fields[$index] ?? ''}}">
                                                    </div>
                                                </div>
                                            @endforeach
                                            <div class="form-group">
                                                <label for="home21_header_section_social_url" class="d-block">{{__('URL')}}</label>
                                                <input type=text class="form-control" value="{{$icon_field}}" name="home21_header_section_social_url[]">
                                            </div>

                                        </div>
                                        <div class="action-wrap">
                                            <span class="add"><i class="ti-plus"></i></span>
                                            <span class="remove"><i class="ti-trash"></i></span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                            <x-media-upload
                                    title="{{__('Bottom Shape Image')}}"
                                    name="home21_header_section_background_image"
                                    id="{{get_static_option('home21_header_section_background_image')}}"
                                    dimentions="770x1050"
                            />
                            <x-media-upload
                                title="{{__('Right Image')}}"
                                name="home21_header_section_right_image"
                                id="{{get_static_option('home21_header_section_right_image')}}"
                                dimentions="770x1050"
                            />
                            <x-media-upload
                                    title="{{__('Text Image')}}"
                                    name="home21_header_section_text_image"
                                    id="{{get_static_option('home21_header_section_text_image')}}"
                                    dimentions="770x1050"
                            />
                            <x-media-upload
                                    title="{{__('Title Shape Image')}}"
                                    name="home21_header_section_title_shape_image"
                                    id="{{get_static_option('home21_header_section_title_shape_image')}}"
                                    dimentions="770x1050"
                            />
                            <x-media-upload
                                    title="{{__('Shape 01 Image')}}"
                                    name="home21_header_section_shape_01_image"
                                    id="{{get_static_option('home21_header_section_shape_01_image')}}"
                                    dimentions="770x1050"
                            />
                            <x-media-upload
                                    title="{{__('Shape 02 Image')}}"
                                    name="home21_header_section_shape_02_image"
                                    id="{{get_static_option('home21_header_section_shape_02_image')}}"
                                    dimentions="770x1050"
                            />
                            <x-media-upload
                                    title="{{__('Shape 03 Image')}}"
                                    name="home21_header_section_shape_03_image"
                                    id="{{get_static_option('home21_header_section_shape_03_image')}}"
                                    dimentions="770x1050"
                            />
                            <button type="submit" class="btn btn-primary mt-4 pr-4 pl-4">{{__('Update Settings')}}</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('backend.partials.media-upload.media-upload-markup')
@endsection

@section('script')
    <script src="{{asset('assets/backend/js/dropzone.js')}}"></script>
    <script src="{{asset('assets/backend/js/summernote-bs4.js')}}"></script>
    @include('backend.partials.media-upload.media-js')
    <script>
        $(document).ready(function () {

            $('.summernote').summernote({
                height: 200,   //set editable area's height
                codemirror: { // codemirror options
                    theme: 'monokai'
                }
            });


            $(document).on('click','.all-field-wrap .action-wrap .add',function (e){
                e.preventDefault();

                var el = $(this);
                var parent = el.parent().parent();
                var container = $('.all-field-wrap');
                var clonedData = parent.clone();
                var containerLength = container.length;
                clonedData.find('#myTab').attr('id','mytab_'+containerLength);
                clonedData.find('#myTabContent').attr('id','myTabContent_'+containerLength);
                var allTab =  clonedData.find('.tab-pane');
                allTab.each(function (index,value){
                    var el = $(this);
                    var oldId = el.attr('id');
                    el.attr('id',oldId+containerLength);
                });
                var allTabNav =  clonedData.find('.nav-link');
                allTabNav.each(function (index,value){
                    var el = $(this);
                    var oldId = el.attr('href');
                    el.attr('href',oldId+containerLength);
                });

                parent.parent().append(clonedData);

                if (containerLength > 0){
                    parent.parent().find('.remove').show(300);
                }
                parent.parent().find('.iconpicker-popover').remove();
                parent.parent().find('.icp-dd').iconpicker();

            });

            $(document).on('click','.all-field-wrap .action-wrap .remove',function (e){
                e.preventDefault();
                var el = $(this);
                var parent = el.parent().parent();
                var container = $('.all-field-wrap');

                if (container.length > 1){
                    el.show(300);
                    parent.hide(300);
                    parent.remove();
                }else{
                    el.hide(300);
                }
            });

        });
    </script>
@endsection
